#include "StdAfx.h"
#include "ConnHand.h"
#include "resource.h"
#include "options.h"
#include "Contentlist.h"

ConnHand::ConnHand(void)
{
	if (!::FileExists(L"cache"))
		_wmkdir(L"cache");
	if (!::FileExists(L"cache\\temp"))
		_wmkdir(L"cache\\temp");
	fileno = 0;
}

ConnHand::~ConnHand(void)
{
}

bool ConnHand::ValidateConn(COptions * in_opt)
{
	opt = in_opt;
	if (opt->m_OpenVia == 0)
	{
		m_LogonInfo.SetHost(opt->ftphost,opt->m_Port,opt->m_Username.GetString(),opt->m_Password.GetString());

		if (!m_FTPClient.Login(m_LogonInfo))
		{
			MessageBox(NULL,L"Unbable to connect to ftp",L"Error",MB_OK);
			return false;
		}
		nsFTP::TStringVector vstrFileList;
		m_FTPClient.List(L"\\",vstrFileList);

		if (vstrFileList.size() == 0)
		{
			MessageBox(NULL,L"Error reading ftp contents",L"Error",MB_OK);
			return false;
		}

		if (opt->m_XBoxDrive == 0)
		{
			//m_FTPClient.ChangeWorkingDirectory("\\usb0\\fsdata\\");
			m_FTPClient.List(L"\\usb0\\fsdata\\",vstrFileList);
			if (vstrFileList.size() == 0)
			{
				MessageBox(NULL,L"No dashboard index file found on usb drive on xbox, please ensure you are running the dashboard.",L"Error",MB_OK);
				return false;
			}
			datapath = L"\\usb0\\fsdata\\";
		} else {
			//m_FTPClient.ChangeWorkingDirectory("\\hdd1\\fsdata\\");
			m_FTPClient.List(L"\\hdd1\\fsdata\\",vstrFileList);
			if (vstrFileList.size() == 0)
			{
				MessageBox(NULL,L"No dashboard index file found on hdd drive on xbox, please ensure you are running the dashboard.",L"Error",MB_OK);
				return false;
			}
			datapath = L"\\hdd1\\fsdata\\";
		}
	} else {

		wstring usb = opt->m_USBDrive;

		datapath = usb.substr(0,1) + L":\\fsdata\\";

		if (!FileExists(datapath + L"content.xml"))
		{
			MessageBox(NULL,L"No dashboard index file found on usb drive, please ensure you have selected the correct drive and have run the dashboard at least once.",L"Error",MB_OK);
			return false;
		}

	}

	return true;
}

wstring ConnHand::GetTempFile(wstring ext)
{
	if (ext.empty())
		return sprintfa(L"cache\\temp\\%d",fileno++);
	
	return sprintfa(L"cache\\temp\\%d.%s",fileno++,ext.c_str());
}

XMLReader* ConnHand::LoadConfigFile(wstring configfile, wstring path)
{
	wstring tempfile = GetTempFile();
	wstring fullname = configfile;

	if (path.size() > 0)
		fullname = path + L"\\" + configfile;

	// FTP so copy file local and delete when read
	if (opt->m_OpenVia == 0)
	{
		m_FTPClient.DownloadFile(fullname,tempfile);
		fullname = tempfile;
	}

	if (!::FileExists(fullname)) return NULL;

	XMLReader* xml = ::LoadConfigFile(fullname);

	_wunlink(tempfile.c_str());

	return xml;
}

errno_t ConnHand::WriteFile(FILE ** fp,wstring Filename)
{
	if (opt->m_OpenVia == 0)
	{
		wstring tempfile = GetTempFile();		
		errno_t res = _wfopen_s(fp,tempfile.c_str(),L"wb");
		if (res == 0)
		{
			OpenFiles[*fp].FTPFile = Filename;
			OpenFiles[*fp].TempFile = tempfile;
		}
		return res;
	} else {
		return _wfopen_s(fp,Filename.c_str(),L"wb");
	}
}

void ConnHand::CloseFile(FILE * fp)
{
	if (opt->m_OpenVia == 0)
	{
		fclose(fp);
		map <FILE *,OpenFileDef>::iterator itr;
		itr = OpenFiles.find(fp);
		if (itr != OpenFiles.end())
		{
			wstring TempFile = (*itr).second.TempFile;
			wstring FTPFile = (*itr).second.FTPFile;

			m_FTPClient.UploadFile(TempFile,FTPFile);

			_wunlink(TempFile.c_str());
		} else {

		}
	} else {
		fclose(fp);
	}
}

int ConnHand::_FileExists(wstring filename)
{
	if (opt->m_OpenVia == 0)
	{
		filename = make_lowercase(str_replaceall(filename,L"\\\\",L"\\"));
		wstring folder = filename.substr(0,filename.rfind(L"\\")+1);

		if (folder != existPath)
		{
			m_FTPClient.List(folder.c_str(),existFiles);
			existPath = folder;
		}

		nsFTP::TStringVector::iterator itr;
		for (itr = existFiles.begin() ; itr != existFiles.end() ; itr++)
		{
			wstring remotefilename = (*itr);
			remotefilename = make_lowercase(str_replaceall(remotefilename,L"\\\\",L"\\"));

			if (remotefilename == filename)
				return true;
		}

		return false;
	} else {
		return ::FileExists(filename);
	}
}

void ConnHand::Mkdir(wstring dir)
{
	if (opt->m_OpenVia == 0)
	{
		m_FTPClient.MakeDirectory(dir);
	} else {
		_wmkdir(dir.c_str());
	}
}

wstring ConnHand::DownloadFile(wstring file)
{
	if (opt->m_OpenVia == 0)
	{
		wstring ext = FileExt(file);
		wstring tempfile = GetTempFile(ext);
		m_FTPClient.DownloadFile(file,tempfile);
		m_FTPClient.Logout();
		m_FTPClient.Login(m_LogonInfo);
		return tempfile;
	}

	return file;
}

bool ConnHand::UplodaFile(wstring source, wstring dest)
{
	if (opt->m_OpenVia == 0)
	{
		bool Ok = m_FTPClient.UploadFile(source,dest);
		m_FTPClient.Logout();
		m_FTPClient.Login(m_LogonInfo);
		return Ok;
	} else {
		return CopyFile(source.c_str(),dest.c_str(),false);
	}
}

void ConnHand::DeleteFile(wstring file)
{
	if (opt->m_OpenVia == 0)
	{
		m_FTPClient.Delete(file);
	} else {
		_wunlink(file.c_str());
	}
}